<?php
/* --------------------------------------------------------------
 ContentNavigation.php 2019-12-12
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Application\Http;

/**
 * Class ContentNavigation
 * @package Gambio\Core\Application\Http
 */
class ContentNavigation
{
    /**
     * @var ContentNavigationItem[]
     */
    private $items = [];
    
    
    /**
     * Adds a new content navigation item.
     *
     * @param string $name
     * @param string $url
     * @param bool   $current
     */
    public function add(string $name, string $url, bool $current): void
    {
        $this->items[] = ContentNavigationItem::create($name, $url, $current);
    }
    
    
    /**
     * Adds a new content navigation item.
     *
     * @param ContentNavigationItem $item
     */
    public function addItem(ContentNavigationItem $item): void
    {
        $this->items[] = $item;
    }
    
    
    /**
     * Array serialization.
     *
     * @return array
     */
    public function toArray(): array
    {
        if (count($this->items) === 0) {
            return [];
        }
        
        $data = [];
        foreach ($this->items as $item) {
            $data[] = $item->toArray();
        }
        
        return array_merge(...$data);
    }
}